//
//  BIIdleManager.h
//  BISubstrate
//
//  Created by Eric Hochmeister on 17/11/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

/*!
    @class       BIIdleManager
    @abstract    The Idle Manager handles tracking when Billings becomes idle and not-idle.
    @discussion  The Idle Manager will post notifications when Billings becomes idle and no longer idle.
 
                 When idle we fire, BIMachineIsIdleNotification
 
                 When no longer idle we fire, BIMachineIsActiveNotification
 
                 Note that Billings is tracking when the machine is idle, not when Billings the application is idle.
                 As well, when we post the no longer idle notification, we pass the number of seconds we were idle in the userInfo dictionary with the key idleTimeInSecs
*/


#import <Cocoa/Cocoa.h>

@class BIDatabaseObjectContext;

@interface BIIdleManager : NSObject {
    BOOL                    isSetup;
	BOOL					isIdle;
	CFTimeInterval			lastSeenIdle;
	NSTimer					*idleTimer;	    
    int machineIdleThreshold;
    
    BIDatabaseObjectContext* _context;
}

- (id)initWithObjectContext:(BIDatabaseObjectContext*)context;

- (BIDatabaseObjectContext*)objectContext;
- (void)setObjectContext:(BIDatabaseObjectContext*)context;

- (int)machineIdleThreshold;
- (void)setMachineIdleThreshold:(int)numSecs;

- (void)invalidateTimer;

@end
